<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--BEGIN LOCALIZATION -->
	<!--Shapes-->
	<xsl:variable name="valRect">Rectangle</xsl:variable>
	<xsl:variable name="valRRect">Rounded Rectangle</xsl:variable>
	<xsl:variable name="valPortal">Portal</xsl:variable>
	<xsl:variable name="valOval">Oval</xsl:variable>
	<xsl:variable name="valLine">Line</xsl:variable>	
	<xsl:variable name="valGraphic">Graphic</xsl:variable>
	
	<!--Sort-->
	<xsl:variable name="valAscending">Ascending order</xsl:variable>
	<xsl:variable name="valDescending">Descending order</xsl:variable>
	<xsl:variable name="valCustomValueList">Custom order based on value list</xsl:variable>
	<xsl:variable name="valReorderSummaryField">Reorder based on summary field</xsl:variable>
	<xsl:variable name="valOverrideFieldLang">Override field's language for sort</xsl:variable>
	
	<!--Overview-->	
	<xsl:variable name="valBackToOverview">Back to Overview</xsl:variable>
	<xsl:variable name="valReportCreated">Report Created</xsl:variable>
	<xsl:variable name="valReportOverview">Report Overview</xsl:variable>
	<xsl:variable name="valFileName">File Name</xsl:variable>
	
	<!--Layout -->
	<xsl:variable name="valShowRecordsFrom">Show Records From</xsl:variable>
	<xsl:variable name="valSaveRecordChanges">Save record changes automatically</xsl:variable>
	<xsl:variable name="valShowFieldFrames">Show field frames when record is active</xsl:variable>
	<xsl:variable name="valContainsFields">Contains Fields</xsl:variable>
	<xsl:variable name="valContainsButtons">Contains Buttons</xsl:variable>
	<xsl:variable name="valUsedInScripts">Used in Scripts</xsl:variable>	
	
	<!--Title-->
	<xsl:variable name="valDatabaseDesignReport">FileMaker Database Design Report</xsl:variable>
	<xsl:variable name="valFileOptionOverview">Overview/File Options</xsl:variable>
	
	<!--Script name-->
	<xsl:variable name="valRunScriptFullAccess">Run script with full access privileges</xsl:variable>
	<xsl:variable name="valLayoutsUseThisScript">Layouts that use this script</xsl:variable>
	<xsl:variable name="valScriptsUseThisScript">Scripts that use this script</xsl:variable>
	<xsl:variable name="valScriptDefinition">Script Definition</xsl:variable>
	<xsl:variable name="valScriptSteps">Script Steps</xsl:variable>
	<xsl:variable name="valFieldsUsedInScript">Fields used in this script</xsl:variable>
	<xsl:variable name="valTablesUsedInScript">Tables used in this script</xsl:variable>
	<xsl:variable name="valTableOccurrencesUsedInScript">Table occurrences used by this script</xsl:variable>
	<xsl:variable name="valLayoutsUsedInScript">Layouts used in this script</xsl:variable>
	<xsl:variable name="valCustomFunctionsUsedInScript">Custom Functions used by this script</xsl:variable>
	<xsl:variable name="valScriptsUsedInScript">Scripts used in this script</xsl:variable>
	
	<!--Value list-->
	<xsl:variable name="valSource">Source</xsl:variable>
	<xsl:variable name="valValues">Values</xsl:variable>		
	<xsl:variable name="valExternal">External</xsl:variable>
	
	<!--Account-->
	<xsl:variable name="valAccountName">Account Name</xsl:variable>
	<xsl:variable name="valPassword">Password</xsl:variable>
	<xsl:variable name="valStatus">Status</xsl:variable>
	<xsl:variable name="valChangePassword">User must change password on next login</xsl:variable>
	<xsl:variable name="valActive">Active</xsl:variable>
	<xsl:variable name="valInactive">Inactive</xsl:variable>
	<xsl:variable name="valExternalServer">External Server</xsl:variable>
	<xsl:variable name="valFileMaker">FileMaker</xsl:variable>
	<xsl:variable name="valAccountNameAndPassword">Account Name and Password</xsl:variable>
	
	<!--File reference-->
	<xsl:variable name="valPathList">File Path List (in search order)</xsl:variable>
	
	<!--Custom function -->
	<xsl:variable name="valFunctionName">Function Name</xsl:variable>
	<xsl:variable name="valParameters">Parameters</xsl:variable>
	<xsl:variable name="valAvailability">Availability</xsl:variable>
	<xsl:variable name="valDefinition">Definition</xsl:variable>
	<xsl:variable name="valAllAccounts">All accounts</xsl:variable>
	<xsl:variable name="valOnlyAccountsFullPrivilege">Only accounts assigned full access privileges</xsl:variable>
	
	<!--Privileges-->
	<xsl:variable name="valDescription">Description</xsl:variable>
	<xsl:variable name="valUsedBy">Used by</xsl:variable>
	<xsl:variable name="valDataAccessAndDesign">Data Access and Design</xsl:variable>
	<xsl:variable name="valrecord">record</xsl:variable>
	<xsl:variable name="valrecords">records</xsl:variable>
	<xsl:variable name="valRecords">Records</xsl:variable>
	<xsl:variable name="valAllowCreationLayouts">Allow creation of new layouts</xsl:variable>
	<xsl:variable name="valAllowCreationValueLists">Allow creation of new value lists</xsl:variable>
	<xsl:variable name="valAllowCreationScripts">Allow creation of new scripts</xsl:variable>
	<xsl:variable name="valLayoutAccess">Layout Access</xsl:variable>
	<xsl:variable name="valAssociatedTableOccurrence">Associated Table Occurrence</xsl:variable>
	<xsl:variable name="valDataAccess">Data Access</xsl:variable>
	<xsl:variable name="valValueListName">Value List Name</xsl:variable>
	<xsl:variable name="valValueListAccess">Value List Access</xsl:variable>
	<xsl:variable name="valScriptAccess">Script Access</xsl:variable>
	<xsl:variable name="valScriptName">Script Name</xsl:variable>
	<xsl:variable name="valNotes">Notes</xsl:variable>
	<xsl:variable name="valOtherPrivileges">Other privileges</xsl:variable>
	<xsl:variable name="valAllowPrinting">Allow printing</xsl:variable>
	<xsl:variable name="valAllowExporting">Allow exporting</xsl:variable>
	<xsl:variable name="valManageExtPrivileges">Manage extended privileges</xsl:variable>
	<xsl:variable name="valAllowDataValidation">Allow user to override data validation warnings</xsl:variable>
	<xsl:variable name="valDisconnectFromFMServer">Disconnect user from FileMaker server when idle</xsl:variable>
	<xsl:variable name="valAllowModifyPassword">Allow user to modify their own password</xsl:variable>
	<xsl:variable name="valAvailableMenuCommands">Available menu commands</xsl:variable>
	<xsl:variable name="valEditingOnly">Editing only</xsl:variable>
	<xsl:variable name="valMinimal">Minimal</xsl:variable>
	<xsl:variable name="valExpiraryDate">Expiry date</xsl:variable>
	<xsl:variable name="valMinPasswordLength">Minimum password length</xsl:variable>
	<xsl:variable name="valCharacters">characters</xsl:variable>
	<xsl:variable name="valDays">days</xsl:variable>
	<xsl:variable name="valExtendedPrivileges">Extended Privileges</xsl:variable>
	<xsl:variable name="valKeyword">Keyword</xsl:variable>
	<xsl:variable name="valNone">None</xsl:variable>
	
	<!--Access Level -->
	<xsl:variable name="valViewOnly">View only</xsl:variable>
	<xsl:variable name="valExecutableOnly">Executable only</xsl:variable>
	<xsl:variable name="valCreateEdit">Create, and edit</xsl:variable>
	<xsl:variable name="valCreateEditDelete">Create, edit, and delete</xsl:variable>
	<xsl:variable name="valModifiable">Modifiable</xsl:variable>
	<xsl:variable name="valNoAccess">No access</xsl:variable>
	<xsl:variable name="valCustom">Custom</xsl:variable>
	<xsl:variable name="valLimited">Limited</xsl:variable>
	<xsl:variable name="valAll">All</xsl:variable>
	
	<!--Access section -->
	<xsl:variable name="valView">View</xsl:variable>
	<xsl:variable name="valEdit">Edit</xsl:variable>
	<xsl:variable name="valCreate">Create</xsl:variable>
	<xsl:variable name="valFieldAccess">Field Access</xsl:variable>
	<!--Overview -->
	<xsl:variable name="valOverview">Overview</xsl:variable>
	
	<!--File options -->
	<xsl:variable name="valFileOptions">File Options</xsl:variable>
	<xsl:variable name="valWhenOpeningFile">When opening file</xsl:variable>
	<xsl:variable name="valWhenClosingFile">When closing file</xsl:variable>
	<xsl:variable name="valLoginUsing">Login using</xsl:variable>
	<xsl:variable name="valSwitchToLayout">Switch to layout</xsl:variable>
	<xsl:variable name="valPerformScript">Perform script</xsl:variable>						
	
	<xsl:variable name="valOn">On</xsl:variable>
	<xsl:variable name="valOff">Off</xsl:variable>
	
	<!--Different report sections -->	
	<xsl:variable name="valTables">Tables</xsl:variable>
	<!--Plural-->
	<xsl:variable name="valFields">Fields</xsl:variable>
	<!--Singular-->
	<xsl:variable name="valField">Field</xsl:variable>	
	<!--Plural-->
	<xsl:variable name="valRelationships">Relationships</xsl:variable>
	<!--Singular-->
	<xsl:variable name="valRelationship">Relationship</xsl:variable>
	<xsl:variable name="valLayouts">Layouts</xsl:variable>
  <!-- new for 11.0 -->  
  <xsl:variable name="valLayoutHierarchy">Layout Hierarchy</xsl:variable>
  <!-- end of new for 11.0 -->
  <xsl:variable name="valScripts">Scripts</xsl:variable>					
	<!-- new for 9.0 -->
	<xsl:variable name="valScriptHierarchy">Script Hierarchy</xsl:variable>
	<!-- end of new for 9.0 -->
	<xsl:variable name="valValueLists">Value Lists</xsl:variable>					
	<xsl:variable name="valCustomFunctions">Custom Functions</xsl:variable>					
	<xsl:variable name="valAccounts">Accounts</xsl:variable>					
	<xsl:variable name="valAccount">Account</xsl:variable>
	<xsl:variable name="valPrivilegeSets">Privilege Sets</xsl:variable>
	<!-- Singular -->
	<xsl:variable name="valPrivilegeSet">Privilege Set</xsl:variable>				
	<xsl:variable name="valFileReferences">FileMaker Data Sources</xsl:variable>										
	<!-- new for 9.0 -->
	<xsl:variable name="valOdbcDataSources">ODBC Data Sources</xsl:variable>
	<xsl:variable name="valName">Name</xsl:variable>
	<xsl:variable name="valDSN">DSN</xsl:variable>
	<xsl:variable name="valAuthentication">Authentication</xsl:variable>
	<xsl:variable name="valFiltering">Filter Tables</xsl:variable>
	<xsl:variable name="valPromptForLogin">Prompt for user name/password</xsl:variable>
	<xsl:variable name="valLoginWithCredentials">Log in with the following credentials (for all users):</xsl:variable>
	<xsl:variable name="valUsername">User name</xsl:variable>
	<xsl:variable name="valLoginWithSingleSignOn">Log in using Windows Single Sign-on</xsl:variable>
	<xsl:variable name="valSPN">Service Provider Name</xsl:variable>
	<xsl:variable name="valFilterTypes">Filter types</xsl:variable>
	<xsl:variable name="valFilterTables">Tables</xsl:variable>
	<xsl:variable name="valFilterViews">Views</xsl:variable>
	<xsl:variable name="valFilterSystemTables">System Tables</xsl:variable>
	<xsl:variable name="valCatalogName">Catalog Name</xsl:variable>
	<!--  xsl:variable name="valTableName">Table Name</xsl:variable  see bug 109387-->
	<xsl:variable name="valSchemaName">Schema Name</xsl:variable>
	<xsl:variable name="valHiddenPassword">Hidden</xsl:variable>
	<!-- new for 9.0 -->
	<!--Table headings for the Tables -->
	<xsl:variable name="valfields">fields</xsl:variable>
	<xsl:variable name="valfield">field</xsl:variable>
	<xsl:variable name="valDefined">defined</xsl:variable>
	<xsl:variable name="valStatistics">Statistics</xsl:variable>	
	<xsl:variable name="valGraphOccurrences">Occurrences in Relationship Graph</xsl:variable>
	
	
	<!--Table headings for the Fields -->
	<xsl:variable name="valTableName">Table Name</xsl:variable>
	<xsl:variable name="valFieldName">Field Name</xsl:variable>
	<xsl:variable name="valType">Type</xsl:variable>
	<xsl:variable name="valOptions">Options</xsl:variable>
	<xsl:variable name="valComments">Comments</xsl:variable>
	<xsl:variable name="valOnLayouts">On Layouts</xsl:variable>
	<xsl:variable name="valInRelationships">In Relationships</xsl:variable>
	<xsl:variable name="valInScripts">In Scripts</xsl:variable>	
	<xsl:variable name="valInValueLists">In Value Lists</xsl:variable>
	<xsl:variable name="valAutoEnter">Auto-Enter</xsl:variable>	
	<xsl:variable name="valValidation">Validation</xsl:variable>
	<xsl:variable name="valStorage">Storage</xsl:variable>
	<xsl:variable name="valDataTypeText">Text</xsl:variable>
	<xsl:variable name="valDataTypeNumber">Number</xsl:variable>
	<xsl:variable name="valDataTypeDate">Date</xsl:variable>
	<xsl:variable name="valDataTypeTime">Time</xsl:variable>
	<xsl:variable name="valDataTypeTimeStamp">Timestamp</xsl:variable>
	<xsl:variable name="valDataTypeBinary">Binary</xsl:variable>	
	<xsl:variable name="valRepetitions">Repetitions</xsl:variable>
	<xsl:variable name="valIndexLanguage">Index Language</xsl:variable>	
	<xsl:variable name="valTableViewVisible">Only visible in Table View</xsl:variable>	
	<xsl:variable name="valTableViewNotVisible">Not visible in Table View</xsl:variable>	
	
	<!-- AutoEnter values -->
	<xsl:variable name="valCreationTime">Creation time</xsl:variable>
	<xsl:variable name="valCreationDate">Creation date</xsl:variable>
	<xsl:variable name="valCreationTimeStamp">Creation timestamp</xsl:variable>
	<xsl:variable name="valCreationName">Creation name</xsl:variable>
	<xsl:variable name="valCreationAccountName">Creation account name</xsl:variable>
	<xsl:variable name="valModificationDate">Modification date</xsl:variable>
	<xsl:variable name="valModificationTime">Modification time</xsl:variable>
	<xsl:variable name="valModificationTimeStamp">Modification timestamp</xsl:variable>
	<xsl:variable name="valModificationName">Modification name</xsl:variable>
	<xsl:variable name="valModificationAccountName">Modification account name</xsl:variable>
	<xsl:variable name="valPreviousRecord">Value from last visited record</xsl:variable>
	<xsl:variable name="valConstantData">Constant data</xsl:variable>
	<xsl:variable name="valAllowEditing">Allow editing</xsl:variable>
	<xsl:variable name="valAlwaysEvaluate">Always evaluate</xsl:variable>
	<xsl:variable name="valSerial">Serial</xsl:variable>
	<xsl:variable name="valGenerate">Generate</xsl:variable>
	<xsl:variable name="valOnCommit">On commit</xsl:variable>
	<xsl:variable name="valOnCreate">On creation</xsl:variable>
	<xsl:variable name="valNextValue">Next value</xsl:variable>
	<xsl:variable name="valIncrement">Increment</xsl:variable>	
	<xsl:variable name="valGlobal">Global</xsl:variable>
	
	<!--Storage-->
	<xsl:variable name="valIndexing">Indexing</xsl:variable>
	<xsl:variable name="valAutoTurnIndexOn">Automatically create indexes as needed</xsl:variable>
	
	<!--Validation values -->
	<xsl:variable name="valAlwaysValidate">Always Validate</xsl:variable>
	<xsl:variable name="valOnlyDuringDataEntry">Only during data entry</xsl:variable>
	<xsl:variable name="valAlwaysValidateCalc">Always validate calculation</xsl:variable>
	<xsl:variable name="valStrictDataType">Strict data type</xsl:variable>
	<xsl:variable name="valFourDigitYear">4 digit year</xsl:variable>
	<xsl:variable name="valNumeric">Numeric</xsl:variable>
	<xsl:variable name="valTimeOfDay">Time of day</xsl:variable>
	<xsl:variable name="valNotEmpty">Not empty</xsl:variable>
	<xsl:variable name="valUnique">Unique</xsl:variable>
	<xsl:variable name="valExisting">Existing</xsl:variable>
	<xsl:variable name="valValueList">Value list</xsl:variable>
	<xsl:variable name="valRange">Range</xsl:variable>		
	<xsl:variable name="valMaxDataLength">Maximum data length</xsl:variable>
	<xsl:variable name="valStrictValidation">Strict validation</xsl:variable>
	<xsl:variable name="valErrorMessage">Error message</xsl:variable>
	
	<!-- Lookup values -->
	<xsl:variable name="valLookup">Lookup</xsl:variable>
	<xsl:variable name="valDoNotCopy">Do not copy</xsl:variable>
	<xsl:variable name="valCopyNextHigher">Copy next higher value</xsl:variable>
	<xsl:variable name="valCopyNextLower">Copy next lower value</xsl:variable>
	<xsl:variable name="valCopyConstant">Copy constant</xsl:variable>
	<xsl:variable name="valDoNotCopyContent">Don't copy contents if empty</xsl:variable>
	
	<!--Summary information -->
	<xsl:variable name="valTotal">Total</xsl:variable>
	<xsl:variable name="valRunningTotal">Running total</xsl:variable>
	<xsl:variable name="valAverage">Average</xsl:variable>
	<xsl:variable name="valWeightedAverage">Weighted average</xsl:variable>
	<xsl:variable name="valCount">Count</xsl:variable>
	<xsl:variable name="valRunningCount">Running count</xsl:variable>
	<xsl:variable name="valMinimum">Minimum</xsl:variable>
	<xsl:variable name="valMaximum">Maximum</xsl:variable>
	<xsl:variable name="valStdDeviation">Standard deviation</xsl:variable>
	<xsl:variable name="valStdDeviationByPopulation">Standard deviation by population</xsl:variable>
	<xsl:variable name="valFractional">Fractional</xsl:variable>
	<xsl:variable name="valFractionalSubtotal">Fractional subtotal</xsl:variable>
	<xsl:variable name="valSummaryField">Summary field</xsl:variable>
	<xsl:variable name="valAdditionalField">Additional field</xsl:variable>
	<xsl:variable name="valTogether">All together</xsl:variable>
	<xsl:variable name="valIndividually">Individually</xsl:variable>

	<!--Table headings for the Layouts -->
	<xsl:variable name="valLayoutName">Layout Name</xsl:variable>
	
	<xsl:variable name="valAssociatedLayouts">Associated with layouts</xsl:variable>
	<!--Field type values -->
	<xsl:variable name="valNormal">Normal</xsl:variable>	
	<xsl:variable name="valCalculated">Calculated</xsl:variable>
	<xsl:variable name="valSummary">Summary</xsl:variable>	
  <xsl:variable name="valInvalid">Invalid</xsl:variable>
	<xsl:variable name="valSummaryInfo">Summary Information</xsl:variable>
	<xsl:variable name="valCalculation">Calculation</xsl:variable>
	<!-- Relationships -->
	<!--Plural-->
	<xsl:variable name="valTableOccurrences">Table Occurrences</xsl:variable>
	<!--Singular-->
	<xsl:variable name="valTableOccurrence">Table Occurrence</xsl:variable>
	<xsl:variable name="valSourceTable">Source Table</xsl:variable>
	<xsl:variable name="valSourceFile">Source File</xsl:variable>
	<xsl:variable name="valInFieldDefinitions">In Field Definitions</xsl:variable>
	<xsl:variable name="valDetails">Details</xsl:variable>
	<xsl:variable name="valFileReference">FileMaker Data Source</xsl:variable>
	<xsl:variable name="valAllowCreationRelatedRecords">Allow creation of records via this relationship</xsl:variable>
	<xsl:variable name="valAllowDeleteRelatedRecords">Delete related records in this table when a record is deleted in the other table</xsl:variable>
	<xsl:variable name="valSortRecords">Sort records</xsl:variable>
	<xsl:variable name="valFilterCalc">Filter calculation</xsl:variable>
	<!-- Relationship -->
	<xsl:variable name="valInfinite">&#8734;</xsl:variable>
	<xsl:variable name="valAnd">and</xsl:variable>
	<xsl:variable name="valEqual">=</xsl:variable>
	<xsl:variable name="valNotEqual">!=</xsl:variable>
	<xsl:variable name="valLessThan">&lt;</xsl:variable>
	<xsl:variable name="valLessThanOrEqualTo">&lt;=</xsl:variable>
	<xsl:variable name="valGreaterThan">&gt;</xsl:variable>
	<xsl:variable name="valGreaterThanOrEqualTo">&gt;=</xsl:variable>
	<xsl:variable name="valCartesianProduct">x</xsl:variable>
	
	<!--Yes, No -->
	<xsl:variable name="valYes">Yes</xsl:variable>
	<xsl:variable name="valNo">No</xsl:variable>
	
	<xsl:variable name="valGroupButton">Group Button</xsl:variable>
	
	<!--Languages-->
	<xsl:variable name="valDefault">Default</xsl:variable>
	<xsl:variable name="valUnicode_Raw">Unicode Raw</xsl:variable>
	<xsl:variable name="valUnicode_Standard">Unicode Standard</xsl:variable>
	<xsl:variable name="valCatalog">Catalog</xsl:variable>
	<xsl:variable name="valCatalan">Catalan</xsl:variable>
	<xsl:variable name="valCroatian">Croatian</xsl:variable>
	<xsl:variable name="valCzech">Czech</xsl:variable>
	<xsl:variable name="valDanish">Danish</xsl:variable>
	<xsl:variable name="valDutch">Dutch</xsl:variable>
	<xsl:variable name="valEnglish">English</xsl:variable>
	<xsl:variable name="valFinnish">Finnish</xsl:variable>
	<xsl:variable name="valFinnish_Custom">Finnish Custom</xsl:variable>
	<xsl:variable name="valFrench">French</xsl:variable>
	<xsl:variable name="valGerman">German</xsl:variable>
	<xsl:variable name="valGerman_Dictionary">German Dictionary</xsl:variable>
	<xsl:variable name="valGreek">Greek</xsl:variable>
	<xsl:variable name="valHungarian">Hungarian</xsl:variable>
	<xsl:variable name="valIcelandic">Icelandic</xsl:variable>
	<xsl:variable name="valItalian">Italian</xsl:variable>
	<xsl:variable name="valJapanese">Japanese</xsl:variable>
	<xsl:variable name="valNorwegian">Norwegian</xsl:variable>
	<xsl:variable name="valPolish">Polish</xsl:variable>
	<xsl:variable name="valPortuguese">Portuguese</xsl:variable>
	<xsl:variable name="valRomanian">Romanian</xsl:variable>
	<xsl:variable name="valRussian">Russian</xsl:variable>
	<xsl:variable name="valSlovak">Slovak</xsl:variable>
	<xsl:variable name="valSlovenian">Slovenian</xsl:variable>
	<xsl:variable name="valSpanish">Spanish</xsl:variable>
	<xsl:variable name="valSpanish_Traditional">Spanish Traditional</xsl:variable>	
	<xsl:variable name="valSwedish">Swedish</xsl:variable>
	<xsl:variable name="valSwedish_Custom">Swedish Custom</xsl:variable>
	<xsl:variable name="valTurkish">Turkish</xsl:variable>
	<xsl:variable name="valUkrainian">Ukrainian</xsl:variable>
	<xsl:variable name="valChinesePinYin">Chinese (Pinyin)</xsl:variable>
	<xsl:variable name="valChineseStroke">Chinese (Stroke)</xsl:variable>

	<!--Furigana -->
	<xsl:variable name="valFurigana">Furigana</xsl:variable>
	<xsl:variable name="valUseFuriganaField">Use furigana field</xsl:variable>
	<xsl:variable name="valTranslateInto">Translate into</xsl:variable>
	<xsl:variable name="valAsIs">As is</xsl:variable>
	<xsl:variable name="valHiragana">Hiragana</xsl:variable>
	<xsl:variable name="valFullWidthKatakana">Full-Width Katakana</xsl:variable>
	<xsl:variable name="valFullWidthRoman">Full-Width Roman</xsl:variable>
	<xsl:variable name="valHalfWidthKatakana">Half-Width Katakana</xsl:variable>
	<xsl:variable name="valHalfWidthRoman">Half-Width Roman</xsl:variable>

	<!--Calculation storage-->
	<xsl:variable name="valDoNotStoreCalcResults">Do not store calculation results</xsl:variable>

	<!--Field Format-->
	<xsl:variable name="valFieldFormat">Field Format</xsl:variable>
	<xsl:variable name="valEditBox">Edit Box</xsl:variable>
	<xsl:variable name="valPopupList">Drop-down List</xsl:variable>
	<xsl:variable name="valPopupMenu">Pop-up Menu</xsl:variable>
	<xsl:variable name="valCheckboxSet">Checkbox Set</xsl:variable>
	<xsl:variable name="valRadioButtonSet">Radio Button Set</xsl:variable>
	<xsl:variable name="valIncludeVScrollBar">Include vertical scrollbar</xsl:variable>
	<xsl:variable name="valDisplayValFrom">Display values from</xsl:variable>
	<xsl:variable name="valIncludeOther">Include &quot;Other...&quot; item to allow entry of other values</xsl:variable>
	<xsl:variable name="valIncludeEdit">Include &quot;Edit...&quot; item to allow editing of value list</xsl:variable>
	<xsl:variable name="valShowRepetition">Show repetition</xsl:variable>
	<xsl:variable name="valThrough">through</xsl:variable>
	<xsl:variable name="valOrientation">Orientation</xsl:variable>
	<xsl:variable name="valHorizontal">horizontal</xsl:variable>
	<xsl:variable name="valVertical">vertical</xsl:variable>

	<!--Field Behaviour-->
	<xsl:variable name="valFieldBehavior">Field Behavior</xsl:variable>
	<xsl:variable name="valAllowFieldEnter">Allow field to be entered</xsl:variable>
	<xsl:variable name="valInBrowseMode">In Browse mode</xsl:variable>
	<xsl:variable name="valInFindMode">In Find mode</xsl:variable>
	<xsl:variable name="valSelectEntireContents">Select entire contents of field on entry</xsl:variable>
	<xsl:variable name="valDisableVisualSpellChecking">Disable visual spell-checking</xsl:variable>
	<xsl:variable name="valSetInputMethod">Set input method to</xsl:variable>
	<xsl:variable name="valGoToNextField">Go to next field using</xsl:variable>
	<xsl:variable name="valTabKey">Tab key</xsl:variable>
	<xsl:variable name="valReturnKey">Return key</xsl:variable>
	<xsl:variable name="valEnterKey">Enter key</xsl:variable>
	<xsl:variable name="valSynchFieldFont">Synchronize with field's font</xsl:variable>
	<xsl:variable name="valJapActive">Japanese (Active Input Mode)</xsl:variable>
	<xsl:variable name="valJapDirect">Japanese (Direct Input)</xsl:variable>
	<xsl:variable name="valFullWidthAlpha">Full-Width Alphanumeric</xsl:variable>
	<xsl:variable name="valHalfWidthAlpha">Half-Width Alphanumeric</xsl:variable>
	<!-- font/fill -->
	<!-- new for 9.0 -->
	<xsl:variable name="valFillColor">Fill Color</xsl:variable>
	<xsl:variable name="valFontFaceBold">Bold</xsl:variable>
	<xsl:variable name="valFontFaceItalic">Italic</xsl:variable>
	<xsl:variable name="valFontFaceUnderline">Underline</xsl:variable>
	<xsl:variable name="valFontFaceCondense">Condense</xsl:variable>
	<xsl:variable name="valFontFaceExtend">Extend</xsl:variable>
	<xsl:variable name="valFontFaceStrikethrough">Strikeout</xsl:variable>
	<xsl:variable name="valFontFaceSmallCaps">Small Caps</xsl:variable>
	<xsl:variable name="valFontFaceSuperscript">Superscript</xsl:variable>
	<xsl:variable name="valFontFaceSubscript">Subscript</xsl:variable>
	<xsl:variable name="valFontFaceUppercase">Uppercase</xsl:variable>
	<xsl:variable name="valFontFaceLowercase">Lowercase</xsl:variable>
	<xsl:variable name="valFontFaceTitleCase">Title Case</xsl:variable>
	<xsl:variable name="valFontFaceWordUnderline">Word Underline</xsl:variable>
	<xsl:variable name="valFontFaceDoubleUnderline">Double Underline</xsl:variable>
	<xsl:variable name="valFontName">Font Name</xsl:variable>
	<xsl:variable name="valFontSize">Font Size</xsl:variable>
	<xsl:variable name="valFontColor">Text Color</xsl:variable>
	<xsl:variable name="valFontStyle">Text Style</xsl:variable>
	<!-- end of new for 9.0 -->
  <!-- new for 11.0 -->
  <xsl:variable name="valFontFaceHighlight">Highlight</xsl:variable>
  <!-- end of new for 11.0 -->

  <!--AutoEnter-->
	<xsl:variable name="valDoNotReplaceExisting">Do not replace existing value for field (if any)</xsl:variable>
	
	<!--Layout Object-->
	<xsl:variable name="valTabs">Tab Controls</xsl:variable>
	<xsl:variable name="valTabControls">Tab Controls</xsl:variable>
	<xsl:variable name="valTabObject">Tab Object</xsl:variable>
	<!-- new for 9.0 -->
	<xsl:variable name="valDefaultFrontTab">Default Front Tab</xsl:variable>
	<xsl:variable name="valTabWidth">Tab Width</xsl:variable>
	<xsl:variable name="valLabelWidth">Label Width</xsl:variable>
	<xsl:variable name="valLabelWidthPlusMarginOf">Label Width + Margin of</xsl:variable>
	<xsl:variable name="valLabelWidthWidest">Width of Widest Label</xsl:variable>
	<xsl:variable name="valLabelWidthMinimumOf">Minimum of</xsl:variable>	
	<xsl:variable name="valLabelWidthFixedOf">Fixed Width of</xsl:variable>		
	<!-- end of new 9.0 -->
	<xsl:variable name="valButtons">Buttons</xsl:variable>
	<xsl:variable name="valPortals">Portals</xsl:variable>
	<xsl:variable name="valTooltip">Tooltip</xsl:variable>
	<xsl:variable name="valTableView">Visibility</xsl:variable>
	<!-- new for 9.0 -->
	<xsl:variable name="valDataSource">Data Source</xsl:variable>
	<xsl:variable name="valDataSources">Data Sources</xsl:variable>
	<xsl:variable name="valShadowTables">Shadow Tables</xsl:variable>
	<xsl:variable name="valShadowFields">shadow fields</xsl:variable>
	<xsl:variable name="valSupplementalFields">supplemental fields</xsl:variable>
	<xsl:variable name="valConditionalFormatting">Conditional Formatting</xsl:variable>
	<xsl:variable name="valDetailsName">Name</xsl:variable>
	<xsl:variable name="valCondition">Condition</xsl:variable>
	<xsl:variable name="valFormat">Format</xsl:variable>
	<xsl:variable name="valFormula">Formula</xsl:variable>
	<xsl:variable name="valCFAnd">and</xsl:variable>
	<xsl:variable name="valDisabled">Disabled</xsl:variable>
	<xsl:variable name="valNotApplied">Not Applied</xsl:variable>
	<xsl:variable name="valCFValueIs">Value is</xsl:variable>
	<xsl:variable name="valCFBetween">between</xsl:variable>
	<xsl:variable name="valCFNotBetween">not between</xsl:variable>
	<xsl:variable name="valCFEqualTo">equal to</xsl:variable>
	<xsl:variable name="valCFNotEqualTo">not equal to</xsl:variable>
	<xsl:variable name="valCFGreaterThan">greater than</xsl:variable>
	<xsl:variable name="valCFLessThan">less than</xsl:variable>
	<xsl:variable name="valCFGreaterThanOrEqualTo">greater than or equal to</xsl:variable>
	<xsl:variable name="valCFLessThanOrEqualTo">less than or equal to</xsl:variable>
	<xsl:variable name="valCFContaining">containing</xsl:variable>
	<xsl:variable name="valCFNotContaining">not containing</xsl:variable>
	<xsl:variable name="valCFBeginningWith">beginning with</xsl:variable>
	<xsl:variable name="valCFEndingWith">ending with</xsl:variable>
	<xsl:variable name="valCFEmpty">empty</xsl:variable>
	<xsl:variable name="valCFBeforeToday">before today</xsl:variable>
	<xsl:variable name="valCFToday">today</xsl:variable>
	<xsl:variable name="valCFAfterToday">after today</xsl:variable>
	<!--
			Localization notice:
			The 4 strings below are meant to construct the English phrase
			"More/less than x days ahead/passed." Since different languages
			will structure this sentence differently, attention must be paid
			to make sure that the below 4 strings are localized correctly.
			
			As a guideline, in HTML we output their values like this:
			valCF[more/less]Than [number] valCFDays[Ahead/Passed].
			
			NEW NOTE: valCFLessThan was already defined.  Don't create duplicate strings!
		-->
	<xsl:variable name="valCFMoreThan">more than</xsl:variable>
	<xsl:variable name="valCFLessThanLET">less than</xsl:variable>
	<xsl:variable name="valCFDaysAhead">days ahead</xsl:variable>
	<xsl:variable name="valCFDaysPassed">days passed</xsl:variable>
	<!-- end of localization notice -->
	<xsl:variable name="valObjectLayoutDetails">Layout Details</xsl:variable>
	<xsl:variable name="valAutoResizeLeftRight">Left and Right</xsl:variable>	
	<xsl:variable name="valAutoResizeTopBottom">Top and Bottom</xsl:variable>	
	<xsl:variable name="valAnchoring">Anchoring</xsl:variable>
	<!-- end of new for 9.0 -->
	<xsl:variable name="valCoordinates">Coordinates</xsl:variable>
	<xsl:variable name="valTop">Top</xsl:variable>
	<xsl:variable name="valLeft">Left</xsl:variable>
	<xsl:variable name="valRight">Right</xsl:variable>
	<xsl:variable name="valBottom">Bottom</xsl:variable>
	<xsl:variable name="valNumberOfObjects"># of Objects</xsl:variable>
	<xsl:variable name="valLayoutObjects">Layout Objects</xsl:variable>
	<xsl:variable name="valFieldObjects">Field Objects</xsl:variable>
	<xsl:variable name="valPanel">Tab</xsl:variable>
	<xsl:variable name="valJustification">Justification</xsl:variable>
	<xsl:variable name="valAppearance">Appearance</xsl:variable>
	<xsl:variable name="valMergeFieldObjects">Merge Field Objects</xsl:variable>
	<xsl:variable name="valPortalObject">Portal Object</xsl:variable>
	<xsl:variable name="valMergeFields">Merge Fields</xsl:variable>
	<xsl:variable name="valText">Text</xsl:variable>
	<xsl:variable name="valButtonScriptStep">Script/Script Step</xsl:variable>
	<xsl:variable name="valButtonObject">Button Object</xsl:variable>
	<xsl:variable name="valTable">Table</xsl:variable>
	<xsl:variable name="valInitRow">Initial Row</xsl:variable>
	<xsl:variable name="valNumOfRows">Number of Rows</xsl:variable>
	<xsl:variable name="valShowVBar">Show vertical scroll bar</xsl:variable>
	<xsl:variable name="valAllowDeletePortalRecords">Allow deletion of portal records</xsl:variable>
	<!-- new for 9.0 -->
	<xsl:variable name="valGraphicObjs">Graphic Objects</xsl:variable>
	<!-- end of new for 9.0 -->
	<xsl:variable name="valGraphicObject">Graphic Object</xsl:variable>
	
	<!--Custom menus-->
	<xsl:variable name="valCustomMenuSets">Custom Menu Sets</xsl:variable>
	<xsl:variable name="valCustomMenus">Custom Menus</xsl:variable>
	<xsl:variable name="valCustomMenuSet">Custom Menu Set</xsl:variable>
	<xsl:variable name="valMenuName">Menu Name</xsl:variable>
	<xsl:variable name="valMenuOptions">Menu Options</xsl:variable>
	<xsl:variable name="valOverrideDisplayTitle">Override Display Title</xsl:variable>
	<xsl:variable name="valMenuPlatform">Menu Platform</xsl:variable>
	<xsl:variable name="valMenuMode">Menu Mode</xsl:variable>
	<xsl:variable name="valWindows">Windows</xsl:variable>
	<xsl:variable name="valMacintosh">Macintosh</xsl:variable>
	<xsl:variable name="valBrowse">Browse</xsl:variable>
	<xsl:variable name="valFind">Find</xsl:variable>
	<xsl:variable name="valPreview">Preview</xsl:variable>
	<xsl:variable name="valMenuItems">Menu Items</xsl:variable>
	<xsl:variable name="valMenuItem">Menu Item</xsl:variable>
	<xsl:variable name="valUsage">Usage</xsl:variable>
	<xsl:variable name="valPlatform">Platform</xsl:variable>
	<xsl:variable name="valOverrideTitle">Override Title</xsl:variable>
	<xsl:variable name="valOverrideAction">Override Action</xsl:variable>
	<xsl:variable name="valOverrideShortcut">Override Shortcut</xsl:variable>
	<xsl:variable name="valMenus">Menus</xsl:variable>
	<xsl:variable name="valMenuSets">Menu Sets</xsl:variable>
	<xsl:variable name="valInLayouts">In Layouts</xsl:variable>
	<xsl:variable name="valCommand">Command</xsl:variable>
	<xsl:variable name="valSubMenu">Sub-menu</xsl:variable>
	<xsl:variable name="valSeparator">Separator</xsl:variable>
	<xsl:variable name="valMissingField">&lt;Missing Field&gt;</xsl:variable>
	<xsl:variable name="valMissingLayout">&lt;Missing Layout&gt;</xsl:variable>
	<xsl:variable name="valMissingValueList">&lt;Missing Valuelist&gt;</xsl:variable>
	<xsl:variable name="valMissingCustomFunction">&lt;Missing Custom Function&gt;</xsl:variable>
	<xsl:variable name="valMissingFileReference">&lt;Missing Data Source&gt;</xsl:variable>
	<xsl:variable name="valMissingBaseTable">&lt;Missing Base Table&gt;</xsl:variable>
	<xsl:variable name="valMissingAccount">&lt;Missing Account&gt;</xsl:variable>
	<xsl:variable name="valMissingExtendedPrivilege">&lt;Missing Extended Privilege&gt;</xsl:variable>
	<xsl:variable name="valMissingScript">&lt;Missing Script&gt;</xsl:variable>
	<xsl:variable name="valMissingCustomMenuSet">&lt;Missing Custom Menu Set&gt;</xsl:variable>
	<xsl:variable name="valMissingCustomMenu">&lt;Missing Custom Menu&gt;</xsl:variable>
	<xsl:variable name="valMissingTableOccurrence">&lt;Missing Table Occurrence&gt;</xsl:variable>
	<xsl:variable name="valMissingPrivilegeSet">&lt;Missing Privilege Set&gt;</xsl:variable>
	
	<xsl:variable name="valShowValuesOnlyFromSecondField">Show values only from second field</xsl:variable>
	<xsl:variable name="valShowValuesOnlyFromPrimaryField">Show values only from primary field</xsl:variable>
	<xsl:variable name="valPrimaryField">Primary Field</xsl:variable>
	<xsl:variable name="valSecondaryField">Secondary Field</xsl:variable>
	<xsl:variable name="valSortByFirstField">Sort by first field</xsl:variable>
	<xsl:variable name="valSortBySecondField">Sort by second field</xsl:variable>
	<xsl:variable name="valRestartForEachSelectedGroup">Restart for each selected group</xsl:variable>
	
	<xsl:variable name="valCtrl">Ctrl/Cmd</xsl:variable>
	<xsl:variable name="valShift">Shift</xsl:variable>
	<xsl:variable name="valAlt">Alt</xsl:variable>
	<xsl:variable name="valPageUp">Page Up</xsl:variable>
	<xsl:variable name="valPageDown">Page Down</xsl:variable>
	<xsl:variable name="valEnd">End</xsl:variable>
	<xsl:variable name="valHome">Home</xsl:variable>
	<xsl:variable name="valLeftArrow">Left Arrow</xsl:variable>
	<xsl:variable name="valUpArrow">Up Arrow</xsl:variable>
	<xsl:variable name="valRightArrow">Right Arrow</xsl:variable>
	<xsl:variable name="valDownArrow">Down Arrow</xsl:variable>
	<xsl:variable name="valInsert">Insert</xsl:variable>
	<xsl:variable name="valDelete">Delete</xsl:variable>
	<xsl:variable name="valHelp">Help</xsl:variable>
	<xsl:variable name="valF1">F1</xsl:variable>
	<xsl:variable name="valF2">F2</xsl:variable>
	<xsl:variable name="valF3">F3</xsl:variable>
	<xsl:variable name="valF4">F4</xsl:variable>
	<xsl:variable name="valF5">F5</xsl:variable>
	<xsl:variable name="valF6">F6</xsl:variable>
	<xsl:variable name="valF7">F7</xsl:variable>
	<xsl:variable name="valF8">F8</xsl:variable>
	<xsl:variable name="valF9">F9</xsl:variable>
	<xsl:variable name="valF10">F10</xsl:variable>
	<xsl:variable name="valF11">F11</xsl:variable>
	<xsl:variable name="valF12">F12</xsl:variable>
	<xsl:variable name="valF13">F13</xsl:variable>
	<xsl:variable name="valF14">F14</xsl:variable>
	<xsl:variable name="valF15">F15</xsl:variable>
	<xsl:variable name="valBack">Back</xsl:variable>
	<xsl:variable name="valClear">Clear</xsl:variable>
	<xsl:variable name="valEscape">Escape</xsl:variable>
	<xsl:variable name="valTab">Tab</xsl:variable>
	<xsl:variable name="valSpace">Space</xsl:variable>
	<xsl:variable name="valReturn">Return</xsl:variable>
	<xsl:variable name="valCapital">Capital</xsl:variable>
	<xsl:variable name="valEnter">Enter</xsl:variable>
	<xsl:variable name="valRounded">Rounded</xsl:variable>
	<xsl:variable name="valSquare">Square</xsl:variable>
	<xsl:variable name="valCenter">Center</xsl:variable>
	<xsl:variable name="valFull">Full</xsl:variable>
	<xsl:variable name="valDropdownCalendar">Drop-down Calendar</xsl:variable>
	<xsl:variable name="valSelectionList">Selection List</xsl:variable>
	<xsl:variable name="valIncludeInMenu">Include In Menu</xsl:variable>
	<xsl:variable name="valQuickFind">Quick Find</xsl:variable>
	<xsl:variable name="valHandCursor">Change to hand cursor over button</xsl:variable>
	<xsl:variable name="valContextTable">Context table</xsl:variable>
	<xsl:variable name="valAllStandardMenus">All Standard Menus</xsl:variable>
	
	<xsl:variable name="valResetScrollBarAfterExit">Reset scroll bar when exiting record</xsl:variable>
	<xsl:variable name="valAutoCompleteUsingValueList">Auto-complete using value list</xsl:variable>
	<xsl:variable name="valAutoCompletePreviousValues">Auto-complete using previously entered values</xsl:variable>
	<xsl:variable name="valIncludeDropIcon">Include icon to show and hide calendar</xsl:variable>
	<xsl:variable name="valIncludeArrow">Include arrow to show and hide list</xsl:variable>
	<xsl:variable name="valDefaultCustomMenuSet">Default custom menu set</xsl:variable>
	<xsl:variable name="valCustomMenuSetUsedByScript">Custom menu set used by this script</xsl:variable>
	<xsl:variable name="valBaseMenu">Base Menu</xsl:variable>
	<xsl:variable name="valFileDefault">[File Default]</xsl:variable>
	<xsl:variable name="valDefaultMenuTitle">Default Display Title</xsl:variable>
	<xsl:variable name="valAt">at</xsl:variable>
	<xsl:variable name="valAtTime">at</xsl:variable>
	
	<!--Newly added strings for 8.5-->
	<xsl:variable name="valFieldProperties">Field Properties</xsl:variable>
	<xsl:variable name="valObjectName">Object Name</xsl:variable>
	<xsl:variable name="valButtonProperties">Button Properties</xsl:variable>
	<xsl:variable name="valAdditionalProperties">Additional Properties</xsl:variable>
	<xsl:variable name="valPortalProperties">Portal Properties</xsl:variable>
	<xsl:variable name="valTabProperties">Tab Control Properties</xsl:variable>
	<xsl:variable name="valPanels">Tabs</xsl:variable>
	<xsl:variable name="valPanelProperties">Tab Properties</xsl:variable>
	<xsl:variable name="valWebControls">Web Viewer Controls</xsl:variable>
	<xsl:variable name="valGraphicObjectProperties">Graphic Object Properties</xsl:variable>
	<xsl:variable name="valRegularFields">Regular Fields</xsl:variable>
	<xsl:variable name="valWebControlProperties">Web Viewer Control Properties</xsl:variable>
	<xsl:variable name="valWebAddress">Web Address</xsl:variable>
	<xsl:variable name="valDisplayContentFindMode">Display Content in Find mode</xsl:variable>
	<xsl:variable name="valAllowInteractWebViewer">Allow interaction with web viewer content</xsl:variable>
	<!-- new for 9.0 -->
	<xsl:variable name="valDisplayProgressBar">Display progress bar</xsl:variable>
	<xsl:variable name="valDisplayStatusMessages">Display status messages</xsl:variable>
	<!-- end of new for 9.0 -->
	<xsl:variable name="valResortLanguage">Re-sort values based on</xsl:variable> 
	<xsl:variable name="valExternalObjects">External Objects</xsl:variable>
	<xsl:variable name="valExternalObjectProperties">External Object Properties</xsl:variable>
	<xsl:variable name="valCalculations">Calculations</xsl:variable>
	<xsl:variable name="valRectangular">Rectangular</xsl:variable>
	<!-- Script Navigation -->
	<!-- new for 9.0 -->
	<xsl:variable name="valPreviousScript">Previous Script</xsl:variable>
	<xsl:variable name="valParentGroup">Parent Folder</xsl:variable>
	<xsl:variable name="valNextScript">Next Script</xsl:variable>
	<!-- end of new for 9.0 -->
	<!-- new for 9.0 -->
	
	<xsl:variable name="valShadow">Shadow</xsl:variable>
	<xsl:variable name="valSupplemental">Supplemental</xsl:variable>
	
	<!-- end of new for 9.0 -->

	<!-- Script Triggers -->
	<!-- new for 10.0 -->
	<xsl:variable name="valScriptTriggers">Script Triggers</xsl:variable>
	<xsl:variable name="valModes">Modes:</xsl:variable>
	<xsl:variable name="valModeBrowse"> Browse</xsl:variable>
	<xsl:variable name="valModeFind"> Find</xsl:variable>
	<xsl:variable name="valModePreview"> Preview</xsl:variable>
	<xsl:variable name="valScriptItem">Script: </xsl:variable>
	<xsl:variable name="valFromFileItem">From file: </xsl:variable>
	<xsl:variable name="valParameterItem">Parameter: </xsl:variable>
	<!-- end of new 10.0 -->

	<!-- File Access Section / Authorized Files Catalog -->
	<xsl:variable name="valSecurity">Security</xsl:variable>
	<xsl:variable name="valFileAccess">File Access</xsl:variable>
	<xsl:variable name="valFileAccessInboundOutbound">File Access (in / out)</xsl:variable>
	<xsl:variable name="valFileAccessOptions">File Access Options</xsl:variable>
	<xsl:variable name="valFileAccessRequireV2">Block access by old clients (before version 11)</xsl:variable>
	<xsl:variable name="valFileAccessRequireAuth">Block access by unauthorized files</xsl:variable>

	<xsl:variable name="valFileAccessInbound">Inbound Authorizations</xsl:variable>
	<xsl:variable name="valFileAccessInboundFiles">Files Authorized to Access This File (In)</xsl:variable>
	<xsl:variable name="valFileAccessAuthUser">Authorized By User</xsl:variable>
	<xsl:variable name="valFileAccessAuthDate">Date of Authorization</xsl:variable>
	
	<xsl:variable name="valFileAccessOutbound">Outbound Authorizations</xsl:variable>
	<xsl:variable name="valFileAccessOutboundFiles">Authorized to Access These Protected Files (Out)</xsl:variable>


  
  <!-- Charting -->
  <!-- new for 11.0 -->
  <xsl:variable name="valChartObjects">Charts</xsl:variable>
  <xsl:variable name="valChartProperties">Chart Properties</xsl:variable>
  <xsl:variable name="valChartTitle">Title</xsl:variable>
  <xsl:variable name="valChartLabel">Label</xsl:variable>
  <xsl:variable name="valChartValue">Value</xsl:variable>
  <xsl:variable name="valChartSeries">Series</xsl:variable>
  <xsl:variable name="varChartSourceFrom">Use Data From</xsl:variable>
  <xsl:variable name="varChartSourceTable">Related Table</xsl:variable>
  <xsl:variable name="varChartAxisInfo">Axis Info</xsl:variable>
  <xsl:variable name="varChartXAxis">X Axis</xsl:variable>
  <xsl:variable name="varChartYAxis">Y Axis</xsl:variable>
  <xsl:variable name="varChartIncludeLegend">Include Legend</xsl:variable>  
  <xsl:variable name="valChartTypeBar">Bar</xsl:variable>
  <xsl:variable name="valChartTypeHBar">Horizontal Bar</xsl:variable>    
  <xsl:variable name="valChartTypeLine">Line</xsl:variable>
  <xsl:variable name="valChartTypeArea">Area</xsl:variable>
  <xsl:variable name="valChartTypePie">Pie</xsl:variable>
  <xsl:variable name="valUnknown">Unknown</xsl:variable>     
  <xsl:variable name="valSeriesSourceDelimited">Current Record (delimited data)</xsl:variable>         
  <xsl:variable name="valSeriesSourceCurrentFoundSet">Current Found Set</xsl:variable>
  <xsl:variable name="valRelatedRecords">Related Records</xsl:variable>
  <xsl:variable name="valShowDataPoints">Show data points for groups of records when sorted</xsl:variable>

  <!-- end of new 11.0 -->
	
  <!--END LOCALIZATION -->
	
	<!-- ************************************************************************************* -->

	<!--DO NOT LOCALIZE ANYTHING BELOW -->
	<!--Cascading style sheet file name -->
	<xsl:variable name="valReportCSS">Styles.css</xsl:variable>
	<xsl:variable name="kGraphicObjects">
		Graphic
		Rect
		RRect
		Line
		Oval
		Text
	</xsl:variable>
	<xsl:variable name="kReportedGraphicAttrs">
		ConditionalFormatting
		ToolTip
	</xsl:variable>
	<!--Use to generate the anchor string so that we can cross reference them -->
	<!--These strings are shared between the xsl files. -->	
	<xsl:variable name="kAnchorTable">TableAnchor_</xsl:variable>
	<xsl:variable name="kAnchorBaseTable">BaseTableAnchor_</xsl:variable>
	<xsl:variable name="kAnchorField">FieldAnchor_</xsl:variable>	
	<xsl:variable name="kAnchorLayout">LayoutAnchor_</xsl:variable>	
	<xsl:variable name="kAnchorLayoutObjects">LayoutObjectsAnchor_</xsl:variable>	
	<xsl:variable name="kAnchorLayoutObject">LayoutObjectAnchor_</xsl:variable>
	<xsl:variable name="kAnchorVL">VLAnchor_</xsl:variable>		
	<xsl:variable name="kAnchorScript">ScriptAnchor_</xsl:variable>
	<xsl:variable name="kAnchorSection">SectionAnchor_</xsl:variable>
	<xsl:variable name="kAnchorRelationship">RelationshipAnchor_</xsl:variable>
	<xsl:variable name="kAnchorFileReference">FileReferenceAnchor_</xsl:variable>
	<xsl:variable name="kAnchorAccount">AccountAnchor_</xsl:variable>
	<xsl:variable name="kAnchorPrivilegeSet">PrivilegeSetAnchor_</xsl:variable>
	<xsl:variable name="kAnchorExtendedPrivilege">ExtendedPrivilegeAnchor_</xsl:variable>
	<xsl:variable name="kAnchorFileAccess">FileAccessAnchor_</xsl:variable>
	<xsl:variable name="kAnchorCustomFunction">CustomFunctionAnchor_</xsl:variable>
	<xsl:variable name="kAnchorCustomMenu">CustomMenuAnchor_</xsl:variable>
	<xsl:variable name="kAnchorCustomMenuSet">CustomMenuSetAnchor_</xsl:variable>
	
	<xsl:template name="ExternalLink-NoAnchor">
		<xsl:param name="inFileLink"/>
		<xsl:param name="inDisplayText"/>		
		<xsl:text disable-output-escaping="yes">
			&lt;a href=&quot;
		</xsl:text>
		<xsl:value-of select="$inFileLink"/>
		<xsl:text disable-output-escaping="yes">
			&quot;&gt;
		</xsl:text>
		<xsl:value-of select="$inDisplayText"/>
		<xsl:text disable-output-escaping="yes">
			&lt;/a&gt;
		</xsl:text>						
	</xsl:template>
	
	<xsl:template name="ExternalLink-NoAnchor-WithTarget">
		<xsl:param name="inFileLink"/>
		<xsl:param name="inTarget"/>
		<xsl:param name="inDisplayText"/>
		<xsl:text disable-output-escaping="yes">
			&lt;a href=&quot;
		</xsl:text>		
		<xsl:value-of select="$inFileLink"/>
		<xsl:value-of select="concat('&quot; target=&quot;',$inTarget, '&quot;&gt;')" disable-output-escaping="yes"/>
		<xsl:value-of select="$inDisplayText"/>
		<xsl:text disable-output-escaping="yes">
			&lt;/a&gt;
		</xsl:text>										
	</xsl:template>
	
	<xsl:template name="ExternalLink-WithAnchor">
		<xsl:param name="inFileLink"/>
		<xsl:param name="inAnchor"/>
		<xsl:param name="inDisplayText"/>
		<xsl:text disable-output-escaping="yes">
			&lt;a href=&quot;
		</xsl:text>
		<xsl:value-of select="concat($inFileLink,'#',$inAnchor)"/>
		<xsl:text disable-output-escaping="yes">
			&quot;&gt;
		</xsl:text>
		<xsl:value-of select="$inDisplayText"/>
		<xsl:text disable-output-escaping="yes">
			&lt;/a&gt;
		</xsl:text>
	</xsl:template>
	
	<xsl:template name="InternalLink-WithAnchor">
		<xsl:param name="inAnchor"/>
		<xsl:param name="inDisplayText"/>
		<xsl:text disable-output-escaping="yes">
			&lt;a href=&quot;
		</xsl:text>
		<xsl:value-of select="concat('#',$inAnchor)"/>
		<xsl:text disable-output-escaping="yes">
			&quot;&gt;
		</xsl:text>
		<xsl:value-of select="$inDisplayText"/>
		<xsl:text disable-output-escaping="yes">
			&lt;/a&gt;
		</xsl:text>
	</xsl:template>	
	
	<xsl:template name="AnchorPoint">
		<xsl:param name="inAnchor"/>
		<xsl:text disable-output-escaping="yes">
			&lt;a name=&quot;
		</xsl:text>
		<xsl:value-of select="$inAnchor"/>
		<xsl:text disable-output-escaping="yes">
			&quot;/&gt;
		</xsl:text>
	</xsl:template>
</xsl:stylesheet>
